package org.msh.tb.export_rest.core;

import java.util.AbstractList;
import java.util.List;

/**
 * A decorator reader that include a prefix in the column titles
 * of a given reader
 * Created by rmemoria on 21/7/17.
 */
public class PrefixedTitleReader implements BlockReader {

    private BlockReader reader;
    private String prefix;

    public PrefixedTitleReader(BlockReader reader, String prefix) {
        this.reader = reader;
        this.prefix = prefix;
    }

    @Override
    public List<String> getColumns() {
        final List<String> columns = reader.getColumns();

        return new AbstractList<String>() {
            @Override
            public String get(int index) {
                return prefix + columns.get(index);
            }

            @Override
            public int size() {
                return columns.size();
            }
        };
    }

    @Override
    public long getRecordCount() {
        return reader.getRecordCount();
    }

    @Override
    public Record current() {
        return reader.current();
    }

    @Override
    public Record next() {
        return reader.next();
    }
}
